;This is a program to be used in the ARRL Project's L/C Circuit Exploration Kit and lessons.
;Program written by: Mark Spencer, WA8SME, ARRL Big Project Coordinator, 225 Main St., Newington,
;CT 06111.  mspencer@arrl.org, 860-594-0396



	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80

;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20

	counter			;used to step through the table that represents digits
	temp
	count
	tempa


;put your variable declarations here

	endc


;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	;call interrupt_service
	return					; interrupt trap - returns without re-enabling

;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1
	call    0x3FF       ; retrieve factory calibration value
						; comment instruction if using simulator, 
	movwf	OSCCAL
	BANKSEL	Bank0		;select bank0
	clrf	PORTA		;clear port bus
	clrf	PORTC
	movlw	b'00000111'	;comparitor disconnected, low power state
	movwf	CMCON		;/
	movlw	b'00000000'	;globals disabled, peripherals disabled,TMR0 disabled
	movwf	INTCON
	movlw	b'10010001'	;right justified,Vdd ref RC0 has ADC, ADC Stop, ADC turned on
	movwf	ADCON0
	movlw	b'00000000'	;TMR1 prescale 1:8, internal clock, TMR1 ON
	movwf	T1CON
	BANKSEL	Bank1		; BANK1
	movlw	b'00000001'	;TMR0 set-up:  pull-ups enabled,X,internal clk,X,
						;pre-scale tmr0, pre-scale 1:2 
	movwf	OPTION_REG	;put w reg into option register
	movlw	b'00010000'	;Fosc/8 for ADC
	movwf	ADCON1
	movlw	b'00000000'	;All outputs 
	movwf	TRISA		;program PORTA
	movlw	b'00000000'	;
	movwf	WPUA
	movlw	b'00000000'	;All output
	movwf	TRISC		;program PORTC
	movlw	b'00000000'	;all digital
	movwf	ANSEL
	movlw	b'00000000'	;TMR1 interrupt enabled
	movwf	PIE1
	movlw	b'00000000'	;allow interrupt on change for RA0 and RA1 for usign sleep mode
	movwf	IOCA	
	BANKSEL	Bank0		;back to bank0

;*****************************************************************************

;*****************************************************************************
;main program
main	
	movlw	.10
	movwf	counter
	
next_count
	decf	counter
	movfw	counter
	call	table_get
	movwf	temp
	andlw	b'00000111'		;mask upper 4 bits
	movwf	PORTA
	rrf		temp,f			;shift out lower 3 bits
	rrf		temp,f
	rrf		temp,f
	movfw	temp
	andlw	b'00001111'
	movwf	PORTC		
	call	wait1sec


	movf	counter
	btfss	STATUS,Z
	goto	next_count
	goto	main




;put your program code here

;*****************************************************************************

interrupt_service			;an interrupt automatically clears GIE to
							;disable interrupts

;put your interrupt service routine here

;*****************************************************************************
	retfie					;sets GIE enabling global interrupts
;*****************************************************************************	


;******************************************************************************
;Delay Routines
;******************************************************************************
wait5sec
		call	wait1sec
		call	wait1sec
		call	wait1sec
		call	wait1sec		;1 seconds plus the one to follow
		

wait1sec
		call	wait300mS
		call	wait300mS
		call	wait300mS
		goto	wait100mS
wait300mS
        call    delay50mS
wait250mS
        call    delay50mS
        call    delay50mS
        call    delay50mS
wait100mS
        call    delay50mS
wait50mS
        call    delay50mS
		return
;delay1ms, is a very accurate 1mS delay for a 4Mhz clock.
delay1mS
        movlw   .198
        movwf   count
        nop
        goto    $+1
        goto    $+1
dly1mS        
        goto    $+1
        decfsz  count, F
        goto    dly1mS
        return
;delay5mS uses delay1mS to get a very accurate 5 mS delay
delay5mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        movlw   .4
        movwf   count
tweek5mS
        decfsz  count, F
        goto    tweek5mS
        return
;delay50mS uses delay1mS to get a very accurate 50mS delay
delay50mS
        movlw   .50
        movwf   tempa
dly50mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly50mS
        movlw   .14
        movwf   count
tweek50mS
        decfsz  count, F
        goto    tweek50mS
        return
;delay200mS uses delay1mS to get a very accurate 200mS delay.
delay200mS
        movlw   .200
        movwf   tempa
dly200mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly200mS
        movlw   .64
        movwf   count
tweek200mS
        decfsz  count, F
        goto    tweek200mS
        return

;table of data to form digits.  
table_get
	addwf	PCL,f		;add the offset to the program counter to jump to character
table	dt	.63, .6, .91, .79, .102, .109, .125, .7, .127, .103
	
end